package jcircus.environment;

import java.util.HashSet;
import java.util.Hashtable;

/**
 * ChannelSetEnv.java
 *
 * @author Angela Freitas
 */
public class ChannelSetEnv {
    
    /**
     * String (channelName) -> HashSet
     *
     * Associates the name of the channel set to a vector of names of sets
     *
     */
    private Hashtable channelSetEnv_;
    
    /**
     * Constructor.
     */
    public ChannelSetEnv() {
        this.channelSetEnv_ = new Hashtable();
    }
    
    /**
     *
     * @param chanSetName
     * @param channelSet
     */
    public void insert(String chanSetName, HashSet channelSet) {
        this.channelSetEnv_.put(chanSetName, channelSet);
    }
    
    /**
     *
     * @param chanSetName
     * @return
     */
    public HashSet get(String chanSetName) {
        return (HashSet) this.channelSetEnv_.get(chanSetName);
    }
    
    /**
     *
     * @param chanSetName
     * @param nameChannel
     */
    public void insert(String chanSetName, String chanName) {
        
        HashSet set;
        
        if (this.channelSetEnv_.containsKey(chanSetName))
            set = (HashSet) this.channelSetEnv_.get(chanSetName);
        else
            set = new HashSet();
        
        set.add(chanName);
        this.channelSetEnv_.put(chanSetName, set);
    }
    
}
